/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.integrations.jei.ingredients;

import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import cy.jdkdigital.productivebees.integrations.jei.ProductiveBeesJeiPlugin;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.setup.BeeReloadListener;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.UidContext;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.TranslatableComponent;

public class BeeIngredientHelper
implements IIngredientHelper<BeeIngredient> {
    @Nonnull
    public IIngredientType<BeeIngredient> getIngredientType() {
        return ProductiveBeesJeiPlugin.BEE_INGREDIENT;
    }

    @Nullable
    public BeeIngredient getMatch(Iterable<BeeIngredient> iterable, BeeIngredient beeIngredient, UidContext uidContext) {
        for (BeeIngredient ingredient : iterable) {
            if (ingredient.getBeeType() != beeIngredient.getBeeType()) continue;
            return ingredient;
        }
        return null;
    }

    @Nonnull
    public String getDisplayName(BeeIngredient beeIngredient) {
        CompoundTag nbt = BeeReloadListener.INSTANCE.getData(beeIngredient.getBeeType().toString());
        if (nbt != null) {
            return new TranslatableComponent("entity.productivebees." + ProductiveBee.getBeeName(beeIngredient.getBeeType().toString()) + "_bee").toString();
        }
        return beeIngredient.getBeeEntity().m_20676_().getString();
    }

    @Nonnull
    public String getUniqueId(BeeIngredient beeIngredient, UidContext uidContext) {
        return "beeingredient:" + beeIngredient.getBeeType();
    }

    @Nonnull
    public String getModId(BeeIngredient beeIngredient) {
        return beeIngredient.getBeeType().m_135827_();
    }

    @Nonnull
    public String getResourceId(BeeIngredient beeIngredient) {
        return beeIngredient.getBeeType().m_135815_();
    }

    @Nonnull
    public BeeIngredient copyIngredient(BeeIngredient beeIngredient) {
        return new BeeIngredient(beeIngredient.getBeeEntity(), beeIngredient.getBeeType());
    }

    @Nonnull
    public String getErrorInfo(@Nullable BeeIngredient beeIngredient) {
        if (beeIngredient == null) {
            return "beeingredient:null";
        }
        if (beeIngredient.getBeeEntity() == null) {
            return "beeingredient:bee:null";
        }
        return "beeingredient:" + beeIngredient.getBeeType();
    }
}

